﻿/*
VERSION:		1.1

USAGE:
	#include "addEventSystem.as"
	addEventSystem( myObject );
	
USAGE:		(internal hook)
	this.doEvent("eventName");
	
USAGE:		(external events)
	myObject.addEvent( "eventName", "functionName", functionParent );
	
	
NOTE:	The big advantage of this event system is that
			it won't call functions within non-existant movieClips.
			Removing a movieClip removes all events associated with it.
			
NOTE:	If a movieClip is deleted,
			and a new one is created with the same name, and same function name
			then the event system will call the new function.
			
NOTE:	This ignores the focusManager.
			When using components, you'll need to confirm their focus manually:
			if( focusManager.getFocus() == this ){ ~~~ }
*/



class EventSystem
{
	static function addEventSystem( target )
	{
		target.event_array = new Array();
		
		
		
		target.doEvent = function( eventName )
		{
			for( var nam in this.event_array )
			{
				var thisEvent = this.event_array[nam];
				
				if( eventName == thisEvent.eventName )
				{// if:  event names match
					thisEvent.parent[thisEvent.callback]();		// call the callback function
				}// if:  event names match
				
				// automatically remove dead events
				if(thisEvent.parent[thisEvent.callback] == undefined)
				{// if:  event doesn't exist anymore
					this.event_array.splice( nam, 1 );
				}// if:  event doesn't exist anymore
			}// for:  event_array
		}// doEvent()
		
		
		
		target.addEvent = function( eventName, callback, parent )
		{
			// search for existing reaction
			var proceed = true;
			for(var e=0; e<this.event_array.length; e++)
			{// for:  event_array
				var thisEvent = this.event_array[e];
				if(thisEvent.eventName == eventName  &&
				   thisEvent.callback == callback  &&
				   thisEvent.parent == parent)
				{// if:  a match is found
					trace("event already exists");
					proceed = false;
				}// if:  a match is found
			}// for:  event_array
			
			if(proceed)
			{// if:  the event doesn't already exist
				// construct event
				var newEvent = new Object();
				newEvent.eventName = eventName;
				newEvent.callback = callback;
				newEvent.parent = parent;
				
				// add event
				this.event_array.push(newEvent);
			}// if:  the event doesn't already exist
		}// addEvent()
		
		
		
		target.removeEvent = function( eventName, callback, parent )
		{
			for(var e=0; e<this.event_array.length; e++)
			{
				var thisEvent = this.event_array[e];
				if(thisEvent.eventName == eventName  &&
				   thisEvent.callback == callback  &&
				   thisEvent.parent == parent)
				{
					// remove this event from the list
					this.event_array.splice( e, 1 );
					e--;		// adjust loop to accomodate the shorter array
				}// if:  a math is found
			}// for:  event_array
		}// removeEvent()
	}// addEventSystem()
}// EventSystem class